@echo off
REM update.bat version 0.1.1

REM 
REM This script is intended to be executed from the mods/ directory of your minecraft instance!
REM DO NOT MOVE THIS FILE.
REM 

REM Step 1. Check if local updater exists, if it doesn't, we can skip this whole comparison deal and just download 
REM the updater
set "local_updater_name=updater_win64.exe"
set "local_ipupdate_name=updateip_win64.exe"
set "local_updater_dir=%~dp0..\scripts"
set "local_mods_path=%~dp0"
set "local_updater_path=%local_updater_dir%/%local_updater_name%"
set "local_ipupdate_path=%local_updater_dir%/%local_ipupdate_name%"
set "remote_mods_uri=https://mc.upsin.net"
set "remote_ip_uri=%remote_mods_uri%/ip"
set "local_server_dat_path=%~dp0..\servers.dat"
set "remote_updater_uri=%remote_mods_uri%/scripts/updater_win64.exe"
set "remote_ipupdate_uri=%remote_mods_uri%/scripts/updateip_win64.exe"

if NOT EXIST %local_updater_dir% (
    md %local_updater_dir%
)

REM Step 2. Compare the remote updater version with the installed one
REM         If they are different, install the version on the remote server
set "local_tmp_dir=%~dp0\\tmp"
set "remote_updater_version_num=%local_tmp_dir%\\remote_version.txt"
set "local_updater_version_num=%local_tmp_dir%\\local_version.txt"

set "remote_ipupdate_version_num=%local_tmp_dir%\\remote_version_ipupdate.txt"
set "local_ipupdate_version_num=%local_tmp_dir%\\local_version_ipupdate.txt"
set "remote_updater_version_uri=%remote_mods_uri%/scripts/updater_win64_version.txt"
set "remote_ipupdate_version_uri=%remote_mods_uri%/scripts/updateip_win64_version.txt"

if NOT EXIST %local_tmp_dir% md %local_tmp_dir%

if EXIST %local_updater_path% (
    call %local_updater_path% --version > %local_updater_version_num%
    powershell -c "Invoke-WebRequest -Uri '%remote_updater_version_uri%' -OutFile '%remote_updater_version_num%'"

    REM compare the files (fc=filecompare?)
    fc /b %local_updater_version_num% %remote_updater_version_num% > nul 2>&1

    REM if an error is raised, the files are different, we should install the one on the remote server
    if errorlevel 1 (
        echo Updating %local_updater_name%
        powershell -c "Invoke-WebRequest -Uri '%remote_updater_uri%' -OutFile '%local_updater_path%'"
    )
) else (
    echo Updating %local_updater_name%
    powershell -c "Invoke-WebRequest -Uri '%remote_updater_uri%' -OutFile '%local_updater_path%'"
)

if EXIST %local_ipupdate_path% (
    call %local_ipupdate_path% --version > %local_ipupdate_version_num%
    powershell -c "Invoke-WebRequest -Uri '%remote_ipupdate_version_uri%' -OutFile '%remote_ipupdate_version_num%'"

    fc /b %local_ipupdate_version_num% %remote_ipupdate_version_num% > nul 2>&1

    if errorlevel 1 (
        echo Updating %local_ipupdate_name%
        powershell -c "Invoke-WebRequest -Uri '%remote_ipupdate_uri%' -OutFile '%local_ipupdate_path%'"
    )
) else (
    echo Updating %local_ipupdate_name%
    powershell -c "Invoke-WebRequest -Uri '%remote_ipupdate_uri%' -OutFile '%local_ipupdate_path%'"
)

REM Step 3. Clean up temporary files
if EXIST %local_tmp_dir% rmdir /s /q %local_tmp_dir%

REM Step 4. Run scripts/updater_win64.exe --url https://mc.upsin.net/mods/ --path . -m mod_manifest.json -y
call %local_updater_path% --url %remote_mods_uri% --path %local_mods_path% --manifest "%~dp0/mod_manifest.json" -y
call %local_ipupdate_path% --url %remote_ip_uri% --force --server "ICW Server" %local_server_dat_path%

IF "%1"=="" (
    REM Step 5. Make sure the user can see output if there was any error
    echo Press any key to exit...
    pause >nul
)
